package gov.va.med.mhv.getcare.util;

import java.io.Serializable;
import java.sql.Timestamp;

import org.apache.commons.lang.StringUtils;

/**
 * Composite transfer object class for the ImpreciseDate composite
 * 
 */
public class ImpreciseDateComposite implements Serializable {

	private static final long serialVersionUID = 789560931750571950L;
	
	private String impreciseValue;
	private Timestamp value;

	ImpreciseDateComposite() {
		
	}
	
	ImpreciseDateComposite(String dateImprecise) {
		this.impreciseValue = dateImprecise;
	}
	/**
	 * Get the impreciseValue
	 *
	 * @return The impreciseValue
	 */
	public String getImpreciseValue() {
		return impreciseValue;
	}
	
	/**
	 * Set the impreciseValue
	 *
	 * @param string The impreciseValue
	 */
	public void setImpreciseValue(String impreciseValue) {
		impreciseValue = StringUtils.trimToNull(impreciseValue);
		this.impreciseValue = impreciseValue;
	}
	

	/**
	 * Get the value
	 *
	 * @return The value
	 */
	public Timestamp getValue() {
		return value;
	}
	
	/**
	 * Set the value
	 *
	 * @param timestamp The value
	 */
	public void setValue(Timestamp value) {
		this.value = value;
	}
}
